<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateSchoolInfoTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 1,
                'unsigned'       => true,
                'auto_increment' => false,
            ],
            'facebook_url' => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],
            'instagram_url' => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],
            'youtube_url' => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],
            'email' => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],

            'visi' => ['type' => 'TEXT', 'null' => true],
            'misi' => ['type' => 'TEXT', 'null' => true],
            'tujuan' => ['type' => 'TEXT', 'null' => true],

            'updated_at' => ['type' => 'DATETIME', 'null' => true],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('school_info', true);

        // bikin 1 baris default (id=1) biar gampang update
        $this->db->table('school_info')->insert(['id' => 1]);
    }

    public function down()
    {
        $this->forge->dropTable('school_info', true);
    }
}
